/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validator.NewLoginValidator.java
 * Desprition : This Validator class is responsible for checking and validating the 
 * Customer's password during Registration .
 * 
 */
package Validators;

import DataClasses.*;
/**
 * @author student
 *
 * This class is being used for validating the password with the verifier.
 * 
 */
public class NewLoginValidator {

	private String message;

	/**
	 * This method is being used for getting the error message if the validation
	 * is unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * This method is being used for setting the error message.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used for validating the password and the verifier.
	 * @param userData The user whose password and verifier are to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(User_Data userData) {

		User_Data userdata = userData;
		String password, verifier;
		password = userdata.getPassword();
		verifier = userdata.getVerifier();

		if (verifier == null || password == null) {
			message = "Either password or verify password field is empty.";
			return false;
		} else if (!verifier.equals(password)) {
			message =
				"The given password does not match the verifying password.";
			return false;
		}
		if (!password.matches("^[a-zA-Z/0-9/'/./-]{4,30}+$")) {
			message = "Password has some invalid characters.";
			message += " Password has to be between 4 and 30 characters long. ";

			return false;
		}
		return true;

	}
}
